/*
 * Created on 04.02.2005
 */
package q1471341.mp1074.test;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import q1471341.util.SwingWorker;

/**
 * This package provides a simple GUI for accessing the various tests
 * provided by the class <code>TestFactory</code>.
 *  
 * @author Ulrich Telle
 */
public class TestFramework implements ActionListener {

	private static final String TEST_ONE                = "TEST-ONE";
	private static final String TEST_DIMENSION          = "TEST-DIMENSION";
	private static final String TEST_CHOICE             = "TEST-CHOICE";
	private static final String TEST_ALPHA              = "TEST-ALPHA";
	private static final String TEST_PERIOD_F2DTEST     = "TEST-PERIOD-F2DTEST";
	private static final String TEST_PERIOD_F1CONST     = "TEST-PERIOD-F1CONST";
	private static final String TEST_GENZ_OSCILLATORY   = "TEST-GENZ-OSCILLATORY";
	private static final String TEST_GENZ_PRODUCT_PEAK  = "TEST-GENZ-PRODUCT-PEAK";
	private static final String TEST_GENZ_CORNER_PEAK   = "TEST-GENZ-CORNER-PEAK";
	private static final String TEST_GENZ_GAUSSIAN      = "TEST-GENZ-GAUSSIAN";
	private static final String TEST_GENZ_CONTINUOUS    = "TEST-GENZ-CONTINUOUS";
	private static final String TEST_GENZ_DISCONTINUOUS = "TEST-GENZ-DISCONTINUOUS";
	private static final String TEST_FIBONACCI          = "TEST-FIBONACCI";
	private static final String TEST_EXIT               = "TEST-EXIT";
	
	private static JFrame frame;
	JMenu testMenu;
	JTextArea output;
  JScrollPane scrollPane;
  String newline = "\n";

  /**
   * Creates the menu bar of the application
   * 
   * @return the created menu bar instance
   */
  public JMenuBar createMenuBar() {
    JMenuBar menuBar;
    JMenu menu, submenu;
    JMenuItem menuItem;
    JRadioButtonMenuItem rbMenuItem;
    JCheckBoxMenuItem cbMenuItem;

    menuBar = new JMenuBar();

    menu = new JMenu("Testauswahl");
    testMenu = menu;
    menu.setMnemonic(KeyEvent.VK_T);
    menu.getAccessibleContext().setAccessibleDescription("Auswahl der verschiedenen Tests");
    menuBar.add(menu);

    menuItem = new JMenuItem("Erster Funktionstest", KeyEvent.VK_F);
    menuItem.setActionCommand(TEST_ONE);
    menuItem.getAccessibleContext().setAccessibleDescription("berprfung der Implementierung");
    menuItem.addActionListener(this);
    menu.add(menuItem);

    menuItem = new JMenuItem("Dimension und Ordnung", KeyEvent.VK_D);
    menuItem.setActionCommand(TEST_DIMENSION);
    menuItem.getAccessibleContext().setAccessibleDescription("Einfluss von Dimension und Ordnung");
    menuItem.addActionListener(this);
    menu.add(menuItem);

    menuItem = new JMenuItem("Wahl der Gitterpunkte", KeyEvent.VK_W);
    menuItem.setActionCommand(TEST_CHOICE);
    menuItem.getAccessibleContext().setAccessibleDescription("Einfluss der Wahl der Gitterpunkte");
    menuItem.addActionListener(this);
    menu.add(menuItem);

    menuItem = new JMenuItem("Optimale Gitterpunkte", KeyEvent.VK_O);
    menuItem.setActionCommand(TEST_ALPHA);
    menuItem.getAccessibleContext().setAccessibleDescription("Optimale Gitterpunkte, Einfluss von Alpha");
    menuItem.addActionListener(this);
    menu.add(menuItem);

    submenu = new JMenu("Periodisierung");
    submenu.setMnemonic(KeyEvent.VK_P);
    submenu.getAccessibleContext().setAccessibleDescription("Einfluss der Periodisierung");

    menuItem = new JMenuItem("1: f(x,y)=y*exp(x*y)/(e-2)", KeyEvent.VK_1);
    menuItem.setActionCommand(TEST_PERIOD_F2DTEST);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menuItem = new JMenuItem("2: f(x,y)=1", KeyEvent.VK_2);
    menuItem.setActionCommand(TEST_PERIOD_F1CONST);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menu.add(submenu);

    submenu = new JMenu("Genz-Tests");
    submenu.setMnemonic(KeyEvent.VK_G);
    submenu.getAccessibleContext().setAccessibleDescription("Genz-Test-Integranden");

    menuItem = new JMenuItem("1: Oszillatorisch", KeyEvent.VK_1);
    menuItem.setActionCommand(TEST_GENZ_OSCILLATORY);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menuItem = new JMenuItem("2: Produkt-Hchstwert", KeyEvent.VK_2);
    menuItem.setActionCommand(TEST_GENZ_PRODUCT_PEAK);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menuItem = new JMenuItem("3: Ecken-Hchstwert", KeyEvent.VK_3);
    menuItem.setActionCommand(TEST_GENZ_CORNER_PEAK);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menuItem = new JMenuItem("4: Normalverteilt", KeyEvent.VK_4);
    menuItem.setActionCommand(TEST_GENZ_GAUSSIAN);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menuItem = new JMenuItem("5: Kontinuierlich", KeyEvent.VK_5);
    menuItem.setActionCommand(TEST_GENZ_CONTINUOUS);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menuItem = new JMenuItem("6: Diskontinuierlich", KeyEvent.VK_6);
    menuItem.setActionCommand(TEST_GENZ_DISCONTINUOUS);
    menuItem.addActionListener(this);
    submenu.add(menuItem);

    menu.add(submenu);

    menuItem = new JMenuItem("Fibonacci-Regeln", KeyEvent.VK_F);
    menuItem.setActionCommand(TEST_FIBONACCI);
    menuItem.getAccessibleContext().setAccessibleDescription("Fibonacci-Gitterpunkt-Formeln");
    menuItem.addActionListener(this);
    menu.add(menuItem);

    menu.addSeparator();

    menuItem = new JMenuItem("Beenden", KeyEvent.VK_B);
    menuItem.setActionCommand(TEST_EXIT);
    menuItem.getAccessibleContext().setAccessibleDescription("Beenden des Programms");
    menuItem.addActionListener(this);
    menu.add(menuItem);

    return menuBar;
  }
  
  /**
   * Creates the content pane holding the textarea for output of the results.
   * 
   * @return the created container
   */
  public Container createContentPane() {
    //Create the content-pane-to-be.
    JPanel contentPane = new JPanel(new BorderLayout());
    contentPane.setOpaque(true);

    //Create a scrolled text area.
    output = new JTextArea(5, 30);
    output.setEditable(false);
    scrollPane = new JScrollPane(output);

    //Add the text area to the content pane.
    contentPane.add(scrollPane, BorderLayout.CENTER);

    return contentPane;
  }
  
  /**
   * Initializes the GUI
   *
   */
  private static void initializeGUI() {
    JFrame.setDefaultLookAndFeelDecorated(true);
    frame = new JFrame("Math. Praktikum 1074: Gitterpunkt-Integrationsformeln");
    frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);


    //Create and set up the content pane.
    TestFramework demo = new TestFramework();
    frame.setJMenuBar(demo.createMenuBar());
    frame.setContentPane(demo.createContentPane());

    //Display the window.
    frame.pack();
    frame.setSize(780, 535);
    frame.setVisible(true);
  }
  
  /**
   * The entry point of the program
   * 
   * @param args
   */
	public static void main(String[] args) {
    try {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    } catch (Exception e) {
    }
    javax.swing.SwingUtilities.invokeLater(new Runnable() {
      public void run() {
          initializeGUI();
      }
    });
	}
	
	/**
	 * Implements the action listener to handle all menu bar events
	 * 
	 */
	public void actionPerformed(ActionEvent e) {
		final TestFramework fw = this;
		final String cmd = e.getActionCommand();
		if (cmd.equals(TEST_EXIT)) {
			System.exit(0);
		}
		final SwingWorker worker = new SwingWorker() {
			public Object construct() {
				testMenu.setEnabled(false);
				Cursor hourglassCursor = new Cursor(Cursor.WAIT_CURSOR);
				fw.output.setCursor(hourglassCursor);
				if (cmd.equals(TEST_ONE)) {
					TestFactory.testImplementation(output);
				} else if (cmd.equals(TEST_DIMENSION)) {
					TestFactory.testDimension(output);
				} else if (cmd.equals(TEST_CHOICE)) {
					TestFactory.testChoice(output);
				} else if (cmd.equals(TEST_ALPHA)) {
					TestFactory.testAlpha(output);
				} else if (cmd.equals(TEST_PERIOD_F2DTEST)) {
					TestFactory.testPeriodizing(output,1);
				} else if (cmd.equals(TEST_PERIOD_F1CONST)) {
					TestFactory.testPeriodizing(output,2);
				} else if (cmd.equals(TEST_GENZ_OSCILLATORY)) {
					TestFactory.testGenz(output, 1, true, GenzTestIntegrands.INTEGRAND_CLASS_GENZ_OSCILLATORY, 2.0);
				} else if (cmd.equals(TEST_GENZ_PRODUCT_PEAK)) {
					TestFactory.testGenz(output, 1, true, GenzTestIntegrands.INTEGRAND_CLASS_GENZ_PRODUCT_PEAK, 2.0);
				} else if (cmd.equals(TEST_GENZ_CORNER_PEAK)) {
					TestFactory.testGenz(output, 1, true, GenzTestIntegrands.INTEGRAND_CLASS_GENZ_CORNER_PEAK, 2.0);
				} else if (cmd.equals(TEST_GENZ_GAUSSIAN)) {
					TestFactory.testGenz(output, 1, true, GenzTestIntegrands.INTEGRAND_CLASS_GENZ_GAUSSIAN, 2.0);
				} else if (cmd.equals(TEST_GENZ_CONTINUOUS)) {
					TestFactory.testGenz(output, 1, true, GenzTestIntegrands.INTEGRAND_CLASS_GENZ_CONTINUOUS, 2.0);
				} else if (cmd.equals(TEST_GENZ_DISCONTINUOUS)) {
					TestFactory.testGenz(output, 1, false, GenzTestIntegrands.INTEGRAND_CLASS_GENZ_DISCONTINUOUS, 2.0);
				} else if (cmd.equals(TEST_FIBONACCI)) {
					TestFactory.testFibonacci(output);
				}
				Cursor normalCursor = new Cursor(Cursor.DEFAULT_CURSOR);
				fw.output.setCursor(normalCursor);
				testMenu.setEnabled(true);
			  return "";
			}
		};
		worker.start();  //required for SwingWorker 3
    output.setCaretPosition(output.getDocument().getLength());
	}
}
