/*
 * Created on 04.01.2005
 */
package q1471341.mp1074.test;

import q1471341.mp1074.integration.Integrand;

/**
 * This package implements two rather simple test integrand functions.
 * 
 * @author Ulrich Telle
 */
public class SimpleTestIntegrands {

	/**
	 * This class represents the 2-dimensional integrand f(x,y) = y*exp(x*y)/(e-2)
	 *  
	 * @author Ulrich Telle
	 */
	public static class F2DTest extends Integrand {
	  private static int s;
	
		/**
		 * Default constructor of class <code>F2DTest</code>
		 */ 
		public F2DTest(int dim) {
			s = dim;
		}
		public int dimension() {
			return s;
		}
		public double evaluate(double[] x) {
			checkArgument(x);
		  double e = Math.exp(1.0);
			double result = x[1] * Math.exp (x[0] * x[1]) / (e - 2.0);
		  return result;
		}
		public String toString() {
			return "y*exp(x*y)/(e-2)";
		}
	}

	/**
	 * This class represents the integrand f = 1
	 *  
	 * @author Ulrich Telle
	 */
	public static class FOne extends Integrand {
	  private static int s;
	
		/**
		 * Default constructor of class <code>FOne</code>
		 */ 
		public FOne(int dim) {
			s = dim;
		}
		public int dimension() {
			return s;
		}
		public double evaluate(double[] x) {
			checkArgument(x);
		  return 1.0;
		}
		public String toString() {
			return "1.0";
		}
	}

}
