/*
 * Created on 10.01.2005
 */
package q1471341.mp1074.integration.lattice;

/**
 * Implements a periodizer based on the trigonometric transformation
 * <code>phi(t) = t-sin(2 pi t) / 2 pi</code> with derivative
 * <code>phi(t)' = 1-cos(2 pi t)</code>.
 * 
 * @author Ulrich Telle
 */
public class Trigonometric1Periodizer implements Periodizer {

	private double dPhi;

	/**
	 * Applies the periodizing transformation on the argument vector <code>x</code>
	 * 
	 * @return the transformed argument vector
	 */
	public double[] periodize(double[] x ){
		int i;
		double t;
		dPhi = 1.0;
		for (i = 0; i < x.length; i++){
			t = x[i];
			x[i] = t - 0.5 * Math.sin(2.0 * Math.PI * t) / Math.PI;
			dPhi *= (1.0 - Math.cos(2.0*Math.PI*t));
		}
		return x;
	}
		
	/**
	 * @return Returns the derivative of the transformed argument vector <code>x</code>
	 */
	public double getDerivative(){
		return dPhi;
	}
}
