/*
 * Created on 10.01.2005
 */
package q1471341.mp1074.integration.lattice;

/**
 * Implements a periodizer based on the polynomial transformation
 * <code>phi(t) = t^3(10-15t+6t^2)</code> with derivative
 * <code>phi(t)' = 30t^2(1-t)^2</code>.
 * 
 * @author Ulrich Telle
 */
public class Polynom2Periodizer implements Periodizer {

	private double dPhi;

	/**
	 * Applies the periodizing transformation on the argument vector <code>x</code>
	 * 
	 * @return the transformed argument vector
	 */
	public double[] periodize(double[] x ){
		int i;
		double t;
		dPhi = 1.0;
		for (i = 0; i < x.length; i++){
			t = x[i];
			x[i] = t*t*t*(10.0+t*(-15.0+6.0*t));
			dPhi *= 30.0*t*t*(1.0-2.0*t+t*t);
		}
		return x;
	}
		
	/**
	 * @return Returns the derivative of the transformed argument vector <code>x</code>
	 */
	public double getDerivative(){
		return dPhi;
	}
}
