/*
 * Created on 10.01.2005
 */
package q1471341.mp1074.integration.lattice;

/**
 * Implements a periodizer based on the polynomial transformation
 * <code>phi(t) = 3t^2-2t^3</code> with derivative
 * <code>phi(t)' = 6t(1-t)</code>.
 * 
 * @author Ulrich Telle
 */
public class Polynom1Periodizer implements Periodizer {

	private double dPhi;

	/**
	 * Applies the periodizing transformation on the argument vector <code>x</code>
	 * 
	 * @return the transformed argument vector
	 */
	public double[] periodize(double[] x ){
		int i;
		double t;
		dPhi = 1.0;
		for (i = 0; i < x.length; i++){
			t = x[i];
			x[i] = (3.0-2.0*t)*t*t;
			dPhi *= 6.0*t*(1.0-t);
		}
		return x;
	}
		
	/**
	 * @return Returns the derivative of the transformed argument vector <code>x</code>
	 */
	public double getDerivative(){
		return dPhi;
	}
}
