/*
 * Created on 10.01.2005
 */
package q1471341.mp1074.integration.lattice;

/**
 * Models the interface of a periodizer for application in
 * periodizing an integrand function for numerical integration
 * using lattice rules which usually require one-periodic integrands.
 *  
 * @author Ulrich Telle
 */
public interface Periodizer {

	/**
	 * Applies the periodizing transformation on the argument vector <code>x</code>
	 * 
	 * @return the transformed argument vector
	 * 
	 * Note: the argument vector is transformed in place, it is returned as
	 * a return value just for convenience.
	 */
	public double[] periodize(double[] x );
	
	/**
	 * @return Returns the derivative of the transformed argument vector <code>x</code>
	 * 
	 * Note: The derivative is calculated when the argument vector is tranformed by the
	 * method <code>periodize</code>.
	 */
	public double getDerivative();
}
