/*
 * Created on 10.01.2005
 */
package q1471341.mp1074.integration.lattice;

/**
 * Implements a periodizer based on the identity transformation
 * <code>phi(t) = t</code> with derivative
 * <code>phi(t)' = 1</code>.
 * 
 * @author Ulrich Telle
 */
public class IdentityPeriodizer implements Periodizer {

	/**
	 * Applies the periodizing transformation on the argument vector <code>x</code>
	 * 
	 * @return the transformed argument vector
	 */
	public double[] periodize(double[] x ){
		return x;
	}
	
	/**
	 * @return Returns the derivative of the transformed argument vector <code>x</code>
	 */
	public double getDerivative(){
		return 1.0;
	}

}
