/*
 * Created on 03.01.2005
 */
package q1471341.mp1074.integration;

import java.util.Random;

/**
 * Performs Monte-Carlo integration, using the java.util.random to generate
 * the inetrgation points.
 * 
 * @author Ulrich Telle
 */
public class MonteCarloIntegrator extends Integrator {
	
	private double     estimatedError;
	private int        numberOfIntegrandEvaluations;
	private Random     random;


	/**
	 * Constructs an instance of a Monte Carlo integrator. 
	 */
	public MonteCarloIntegrator() {
		super();
		random = new Random();
	}

	/**
	 * Performs the Monte Carlo integration of the integrand until one of the
	 * termination conditions is met.
	 * 
	 * @param f integrand function
	 * @return result of integration
	 * @throws IntegrationException if an integration error occurs
	 */
	public IntegrationResult integrate(Integrand f) {
		int s = f.dimension();
	  int j, m;
	  double value;
	  double quad;
	  double quadSum;
	  double quadSquare;
	  double[] x = new double[s];
		
		long startTime = System.currentTimeMillis();

	  m = 0;
	  quadSum = 0.0;
	  quadSquare = 0.0;
		do {
	  	for ( int k = 0; k < s; k++) {
	  		x[k] = random.nextDouble();
	  	}
	  	value = f.evaluate(x);
	  	m++;
			quadSum += value;
			quadSquare += (value*value);
			quad = quadSum / ((double) m );
		}	while (!shouldTerminate(quad,m));
		
		estimatedError = Math.sqrt((quadSquare / (double) m - quad*quad) / (double)(m-1));
		
		IntegrationResult result = 
			new IntegrationResult(quad, estimatedError, m, System.currentTimeMillis()-startTime, getTerminationCondition());
		return result;
	}

	/**
	 * @return Returns the name of this integrator
	 */
	public String toString() {
		return "Monte Carlo Integrator";
	}
}
