/*
 * Created on 03.01.2005
 */
package q1471341.mp1074.integration;

/**
 * The class <code>IntegrationResult</code> models the result of an
 * integration.
 * 
 * The result of an integration consists of the estimated integral value,
 * its estimated error, the number of function evaluations used for the
 * integration, the duration of the integration process and an identification
 * of the termination condition.
 * 
 * @author Ulrich Telle
 */
public class IntegrationResult {

	private double value;
	private double estimatedError;
	private long   evaluationCount;
	private long   evaluationTime;
	private int    terminationCondition;
	 
	/**
	 * Constructs an instance of an integration result.
	 *  
	 * @param value estimated value of the integral
	 * @param estimatedError estimated integation error
	 * @param evaluationCount number of integrand evaluations
	 * @param evaluationTime duration of the integration process
	 * @param terminationCondition identifier of the termination condition
	 */
	public IntegrationResult(double value, double estimatedError,
	 		                      long evaluationCount, long evaluationTime,
														int terminationCondition) {
		this.value = value;
		this.estimatedError = estimatedError;
		this.evaluationCount = evaluationCount;
		this.evaluationTime = evaluationTime;
		this.terminationCondition = terminationCondition;
	}
	
	/**
	 * Returns the estimated integral value. <code>Double.NaN</code> is
	 * returned if no estimate is available.
	 * 
	 * @return integral value
	 */
	public double getValue() {
		return value; 
	}

	/**
	 * Returns the error estimate for the integral value.
	 * <code>Double.NaN</code> is returned if no estimate is available.
	 * 
	 * @return error estimate of integral value
	 */
	public double getEstimatedError() {
		return estimatedError;
	}

	/**
	 * Returns the number of times the integrand function has been evaluated.
	 * 
	 * @return number of evaluations
	 */
	public long getEvaluationCount() {
		return evaluationCount;
	}

	/**
	 * Returns the duration of the integration in milliseconds 
	 * 
	 * @return number of milliseconds
	 */
	public long getEvaluationTime() {
		return evaluationTime;
	}

	/**
	 * Returns the termination condition id 
	 * 
	 * @return termination condition id
	 */
	public long getTerminationCondition() {
		return terminationCondition;
	}
}