/*
 * Created on 03.01.2005
 */
package q1471341.mp1074.integration;

/**
 * Models a mathematical function used as an integrand. The function is a
 * mapping from <i>R^s </i> to <i>R</i>, where <i>R</i> is the real numbers,
 * and <i>s</i> the dimension of the function. The function's dimension <i>s</i>
 * is fixed for any one instance, but may vary between instantiations, for
 * example depending on the constructor. The dimension is obtained by the method
 * <code>getDimension</code>.
 * 
 * @author Ulrich Telle
 */
public abstract class Integrand {

	/**
	 * Returns the dimension of the domain of the function.
	 * 
	 * @return the number of dimensions of the domain of the function
	 */
	abstract public int dimension();

	/**
	 * Evaluates the integrand at the specified point.
	 * 
	 * The method should check for the correct size of the argument vector x.
	 * The protected method <code>checkArgument</code> may be used for this
	 * purpose.
	 * 
	 * @param x   the point in R^s where the integrand is to be evaluated
	 * @return the value of the integrand at x
	 * @throws IllegalArgumentException
	 *             if x.length != dimension of the integrand domain
	 */
	abstract public double evaluate(double[] x);

	/**
	 * This is an internal routine which can be used to check whether the
	 * argument to <code>evaluate</code> has the proper dimension.
	 * 
	 * @param x array to check
	 */
	protected void checkArgument(double[] x) {
		if (x.length != dimension()) {
			throw new IllegalArgumentException("Array size does not match the integrand dimension");
		}
	}
}
